/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;

public class Limiter<T> {
    private final int timeout;
    private final LimiterCallback<T> callback;
    private volatile long lastMessageTime = 0L;
    private Timer timer;
    private AtomicReference<T> pendingMessage;
    private boolean stopped;

    public Limiter(LimiterCallback<T> callback) {
        this(callback, 1000);
    }

    public Limiter(LimiterCallback<T> callback, int timeout) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkArgument(timeout > 0, "Timeout must be positive number.");
        this.callback = callback;
        this.timeout = timeout;
        this.timer = new Timer();
        this.pendingMessage = new AtomicReference();
        this.stopped = false;
    }

    public void process(T message) {
        Preconditions.checkNotNull(message, "Message passed to the limiter cannot be null.");
        Preconditions.checkState(!this.stopped, "Limiter has already been stopped.");
        long msgTime = System.currentTimeMillis();
        long delta = msgTime - this.lastMessageTime;
        if (delta >= (long)this.timeout) {
            this.callback.onMessage(message);
            this.lastMessageTime = msgTime;
        } else {
            T oldMessage = this.pendingMessage.getAndSet(message);
            if (oldMessage == null) {
                this.timer.schedule((TimerTask)new LimiterTimerTask(), (long)this.timeout - delta);
            }
        }
    }

    public void stop() {
        Preconditions.checkState(!this.stopped, "Limiter has already been stopped.");
        this.stopped = true;
        this.timer.cancel();
        Object message = this.pendingMessage.getAndSet(null);
        if (message != null) {
            this.callback.onMessage(message);
        }
    }

    public static interface LimiterCallback<T> {
        public void onMessage(T var1);
    }

    private class LimiterTimerTask
    extends TimerTask {
        private LimiterTimerTask() {
        }

        @Override
        public void run() {
            Object message = Limiter.this.pendingMessage.getAndSet(null);
            if (message != null) {
                Limiter.this.lastMessageTime = System.currentTimeMillis();
                Limiter.this.callback.onMessage(message);
            }
        }
    }
}

